/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.Locale;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class VWPopupMenu
extends JPopupMenu {
    public void show(Component invoker, int x, int y) {
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
        Point p = this.getPopupMenuOrigin(invoker, x, y);
        super.show(invoker, p.x, p.y);
    }

    private Point getPopupMenuOrigin(Component invoker, int x, int y) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension pmSize = this.getSize();
        if (pmSize.width == 0) {
            pmSize = this.getPreferredSize();
        }
        Point absp = new Point(x, y);
        SwingUtilities.convertPointToScreen(absp, invoker);
        int aleft = absp.x + pmSize.width;
        int abottom = absp.y + pmSize.height;
        if (aleft > screenSize.width) {
            x -= aleft - screenSize.width;
        }
        if (abottom > screenSize.height) {
            y -= abottom - screenSize.height + 25;
        }
        return new Point(x, y);
    }
}

